* ITER - iterational procedure for x=F(x) root search.
*        X0 - initial x approximation
*        Eps - some precision for the root: if previous
*        and current estimations are closer than EPS*|Xold-Xnew|
*        then the search is considered done. Is is good for the
*        functions with some bad behavior in the sense of convergence.
*        Parameter Max_Away is a permitted number of consecutive moveme nts of
*        a point, which represents x-value estimation, away form the pr evious
*        one in an increasing distance.
*
*        Error = 0 -- OK; 2001 -- no convergence.
*
* (C) by M.Golub * Moscow * Russia * 1995
* ===========================================================

      Real Function ITER ( Funct, X0, Eps )

      Parameter (Max_Away=5)

      Integer             Error
      Common / FNERR /    Error

      Error = 0
      ITER = X0
      N     = 0
      X_old = ITER
      ITER = Funct( ITER )
      Dist  = Abs( ITER - X_old )
 1    Continue
      Dst   = Dist
      X_old = ITER
      ITER = Funct( ITER )
      Dist  = Abs( ITER - X_old )
      If ( Dist .le. Eps * Abs( ITER ) ) Return
      If ( Dist .ge. Dst ) N = N + 1
      If ( N .gt. Max_Away ) Go to 2001
      GO TO 1
 2001 Continue
      Error = 2001
      Return
      End
