*     Pi_Bench32.For - program for pi calculation as a long digits string
*          with Mechin approach.
*          Created for Fortran-4:  August 14 1989.
*          Updated for Fortran-77: April  29 1992.
*          Last update: 02-11-97 (European format)
*     (C) 1989-1997 AIAP by Golub M.A. Moscow Russia golub@aha.tu
* =========================================================================

      Program Pi_Bench32
      Parameter ( NDM = 16000, NDM1 = NDM + 1 ) ! NB: In.n and low limit
      Character * 50 name, dummy
      Integer     NB( NDM1 ), NC( NDM1 ), N1( NDM1 ), N2( NDM1 )
*NB: MS FORTRAN code is commented out with *MS: at the beginning of the line
*    or ! at the end.
*MS:
*     Integer * 2 hh, mm, ss, sss, h1, m1, s1, ss1
      Character * 10 stm / 'Start time' /, etm / 'End time  ' /
      Character *  8 tm, tm1

      Common   / PIDIM0 / IDM0, NSQRU
      Common   / PIUNIT / NUNIT
      Data       IDIM / NDM /, N5 / 5 /, N239 / 239 /, N4 / 4 /

      NUNIT = 10000
      ! NUNIT - Program tuning number (fortran dependent).
      ! This number must be less power than REAL type significant digits
      ! number.

      RUNIT = NUNIT
      NSQRU = Int( SQRT( RUNIT ) )
      NDIGIT = Int( ALOG10( RUNIT ) + 0.5 )
      ndmm = NDIGIT * NDM

      Print "(' This is a computing power benchmark based on PI number c
     ,alculation.'/' This program updates Pi_Bench.Dat file:  50 charact
     ,ers of a compurer'/' identifier, e.g., [DEC 3000-600s AXP alpha st
     ,ation], are appended with'/' the benchmark value.  The last line o
     ,f the file is thought to contain'/' YOUR COMPUTER NAME, which will
     , be appended with its behchmark parameter'/' if the calculation du
     ,ration is more than 1 second (the timing precision).')"

*MS:
*     Print *, 'Hit Ctrl-Z, Enter or F6, Enter to quit.'
*GNU:
      Print *, 'The last Pi_Bench.Dat line is copied before updating.'
      Print *, 'Hit Ctrl-Z to quit.'

      Do While( .True. )
         Print "(' Enter number of digits for pi [4;', i5, '] ', $)"
     ,,         ndmm
         Read( *, *, IOSTAT = io ) IDIM
         If ( io .ne. 0 ) Stop 901
         Print *
         Print *, IDIM, ' has been entered.'
         If ( IDIM .LT. 4    ) Cycle
         If ( IDIM .LE. ndmm ) Exit
         Print "(' You misspelled.', i6, ' is maximum. Retry, please.')"
     ,,        ndmm
      End Do

      IDM0 = ( IDIM - 1 ) / NDIGIT + 1
      IDM1 = IDM0 * NDIGIT
      IDIM = IDM0 + 1

      Print *, IDM1, ' has been accepted.'

      Open( 1 , File='PI.Tst', IOStat=IOStat)

      If ( IoStat.ne.0 ) Then
         Print *, 'Error opening Pi.Tst'
         Stop 1000
      End If

      Open( 8 , File='PI.OUT', IOStat=IOStat)

      If ( IoStat.ne.0 ) Then
         Print *, 'Error opening Pi.Out'
         Stop 1001
      End If

*MS:
*     Call GetTim( hh, mm, ss, sss )
*GNU:
      Call Time(tm)

      Print 1803, idim
      Write( 1, 1803, Err = 903 ) idim
 1803 Format(' Speed test data: dimension is ', i5)
      Print 1804, stm, tm ! hh, mm, ss, sss
      Write( 1, 1804, Err = 903 ) stm, tm ! hh, mm, ss, sss
 1804 Format( 1x, a, 1x, a) ! 2(i2.2, ':'), i2.2, '.', i2.2)

      Print *, 'Calculating arctg(1/5).'
*GNU:
      ds=Secnds(0.)
      Call ARCTG( N1, NB, NC, IDIM, N5 )

*     Print 1805, ( N1( I ), I = 1, IDM0 )
*1805 Format(' ArcTangent( 1 / 5 ) = 0.', ( T26, 13 I4.4 ) )
      Write( 8, 1801, Err = 903 ) ( N1( I ), I = 1, IDM0 )
 1801 Format( ' ArcTangent( 1 / 5 ) = 0.', ( T26, 25 I4.4 ) )

      Print *, 'Calculating arctg(1/239).'
      Call ARCTG( N2, NB, NC, IDIM, N239 )

*     Print 1806, ( N2( I ), I = 1, IDM0 )
*1806 Format(' ArcTangent( 1/239 ) = 0.', ( T26, 13 I4.4 ) )
      Write( 8, 1802, Err = 903 ) ( N2( I ), I = 1, IDM0 )
 1802 Format( ' ArcTangent( 1/239 ) = 0.', ( T26, 25 I4.4 ) )

      Print *, 'Calculating arctg(1/5)*4.'
      Call Mult ( N1, IDIM, N4 )
      Print *, 'Calculating arctg(1/5)*4-arctg(1/239).'
      Call Subtr( N1, N2, IDIM )
      Print *, 'Calculating pi=(arctg(1/5)*4-arctg(1/239))*4.'
      Call Mult ( N1, IDIM, N4 )

      N1( 1 ) = Mod( N1( 1 ), NUNIT )

*GNU:
      ds=Secnds(ds)
      Call Time(tm1)
*MS:
*     Call GetTim( h1, m1, s1, ss1 )

      Print 1804, etm, tm1 ! h1, m1, s1, ss1
      Write( 1, 1804, Err = 903 ) etm, tm1 ! h1, m1, s1, ss1
*     ds = s1 - ss + ( ss1 - sss ) / 100. + 60. * ( m1 - mm +
*    +                                      60. * ( h1 - hh ) )
      Print *, 'Duration is', ds, ' sec'
      Write( 1, *, Err = 903 ) 'Duration is', ds, ' sec'
*     Print 1808, ( N1( I ), I = 1, IDM0 )
*1808 Format(' Pi = 3.', ( T9, 15 I4.4 ) )
      Write( 8, 1800, Err = 903 ) ( N1( I ), I = 1, IDM0 )
 1800 Format( ' Pi = 3.', ( T9, 25 I4.4 ) )

      rdm=idm1
      If (ds .gt. 1.) Then
         bench=(rdm*6e-4*rdm)/ds
         Open(2, File='Pi_Bench.Dat', Status='Unknown',
     ,        Form='Formatted', IOStat=io)
         If ( IoStat.ne.0 ) Then
            Print *, 'Error opening Pi_Bench.Dat'
            Stop 1002
         End If

         nrec=0

         Do While(.true.)
            Read(2, "(a50)", Err=912, End=911) dummy
            nrec=nrec+1
            name=dummy
         End Do

  911 Continue

*        Rewind(Unit=2, Err=912)
*MS:
*        nrec=nrec-1
*        Do i=1, nrec
*           Read(2, *, Err=912, End=911)
*        End Do
         Print *, name, bench
         Write(2, "(a50, 1x, g15.7)", Err=912) name, bench
      End If

 9999 Stop
  903 Continue
      Print *, 'Write error.'
      Stop 903
  912 Continue
      Print *, 'Error reading/writing benchmark file.'
      Stop 912
      End

*     =============================================================
*     Arctangent calculation for 1 / N argument. Long digits string
*     NA( IDIM ) is formed.
*     =============================================================

      Subroutine ARCTG( NA, NB, NC, IDIM, N )

      Integer   NA( IDIM ), NB( IDIM ), NC( IDIM )


      External  FN

      Common / PIDIM0 / IDM0, NSQRU
      Common / PIUNIT / NUNIT
      Common / PIFUNC / Alpha, Beta

      If ( N .LT. NSQRU ) Then
         N2 = N * N
         I2 = 1
      Else
         N2 = N
         I2 = 2
      End If

      NC( 1 ) = NUNIT
      Call Zero( NC, IDIM, 2 )

      Beta = 1. / ALOG( 1. * N )
      NDIM = Int( ALOG10( 1. * NUNIT ) + 0.5 ) * IDIM
*                    ---------- ln( 10. ) --------------
      Alpha = NDIM * 2.302585 ! 092994045684017991454684

      X  = Alpha
      X  = RIter( FN, X, 0.5 )
      NL = Int( X ) + 1

      Print *, 'Expansion length is considered:', NL
      Print *

      Call Divide( NC, IDIM, N )
      Call Copy  ( NC, NA, IDIM )

      Do I10 = 2, NL, 2
         Do I20 = 1, I2
            Call Divide( NC, IDIM, N2 )
         End Do
         J = 2 * I10 - 1
         Call Copy  ( NC, NB, IDIM )
         Call Divide( NB, IDIM, J )
         Call Subtr ( NA, NB, IDIM )
         DO I30 = 1, I2
            Call Divide( NC, IDIM, N2 )
         End Do
         Call Copy  ( NC, NB, IDIM )
         Call Divide( NB, IDIM, J+2 )
         Call Add   ( NA, NB, IDIM )
*        Print "('+Term #', i5, ' calculated.' )", I10
      End Do
*     Print "( '+Last operand trail: ', 2i4.4 )", NB( IDM0 ), NB( IDIM )
      Return
      END

*     Function for expansion truncation iteration search.
*     ===================================================

      Real Function FN( X )

      Common / PIFUNC / A, B
      FN = ( ( A - ALOG( X ) ) * B + 1. ) * 0.5
      Return
      End

*     ===============================================================
*     *                Arithmetic operations package                *
*     ===============================================================

***** Assignment operation: NX -> NY. *******************************

      Subroutine Copy( NX, NY, IDIM )

      Integer    NX( IDIM ), NY( IDIM )

      Do I10 = 1, IDIM
         NY( I10 ) = NX( I10 )
      End Do

      Return
      End

***** Assignment: NX = 0 ( all digits from J-th ). ******************

      Subroutine Zero( NX, IDIM, J )

      Integer    NX( IDIM )

      Do I10 = J, IDIM
        NX( I10 ) = 0
      End Do

      Return
      End

***** Multiplication: IARR( IDIM ) * MULT2 -> IARR( IDIM ) **********

*     Nota bene: multiplier "MULT2" is a common integer.

      Subroutine Mult( IARR, IDIM, MULT2 )

      Integer    IARR( IDIM )
      Common  / PIUNIT / NUNIT

      NBUFF = 0

      Do I10 = 1, IDIM
         J = IDIM - I10 + 1
         Buffer = IARR( J )
         Buffer = Buffer * MULT2 + NBUFF
         NBUFF = Int( Buffer / NUNIT )
         IARR( J ) = Int( Buffer - 1. * NUNIT * NBUFF + 0.5 )
      End Do

      Return
      End

***** Addition: IARR1 + IARR2 -> IARR1 ******************************

      Subroutine Add( IARR1, IARR2, IDIM )

      Integer    IARR1( IDIM ), IARR2( IDIM )

      Common  / PIUNIT / NUNIT

      NBUFF = 0

      Do I10 = 1, IDIM
         J = IDIM - I10 + 1
         Buffer = IARR1( J )
         Buffer = IARR2( J ) + Buffer + NBUFF
         NBUFF = Int( Buffer / NUNIT )
         IARR1( J )= Int( Buffer - 1. * NUNIT * NBUFF + 0.5 )
      End Do

      Return
      End

***** Subtraction: IARR1 - IARR2 -> IARR1 ***************************

      Subroutine Subtr( IARR1, IARR2, IDIM )

      Integer    IARR1( IDIM ), IARR2( IDIM )

      COMMON  / PIUNIT / NUNIT

      NBUFF = 0

      Do I10 = 1, IDIM
         J = IDIM - I10 + 1
         NSUBT = IARR1( J ) - IARR2( J ) - NBUFF
         NBUFF = 0
         If ( NSUBT .lt. 0 ) Then
            NSUBT = NUNIT + NSUBT
            NBUFF = 1
         End If
         IARR1( J ) = NSUBT
      End Do

      RETURN
      END

***** Division : NARR( IDIM ) / NUMER -> NARR( IDIM ) ***************

*     Nota bene: numerator is a common integer.

      Subroutine Divide( NARR, IDIM, NUMER )

      Integer    NARR( IDIM )

      Common  / PIUNIT / NUNIT

      NREST = 0

      Do I10 = 1, IDIM
         Buffer = NARR( I10 ) + 1. * NREST * NUNIT
         NDIV   = Int( Buffer / NUMER )
         NREST  = Int( Buffer - 1. * NUMER * NDIV + 0.5 )
         NARR( I10 ) = NDIV
      End Do

      Return
      End
* RITER - iterational procedure for x=F(x) root search.
*         X0 - initial x approximation
*         Eps - some precision for the root: if previous
*         and current estimations are closer than EPS*|Xold-Xnew|
*         then the search is considered done. Is is good for the
*         functions with some bad behavior in the sense of convergence.
*         Parameter Max_Away is a permitted number of consecutive movements of
*         a point, which represents x-value estimation, away form the previous
*         one in an increasing distance.
*
*         Error = 0 -- OK; 2001 -- no convergence.
*
* (C) by M.Golub * Moscow * Russia * 1995
* ===========================================================

      Real Function RITER ( Funct, X0, Eps )

      Parameter (Max_Away=5)

      Integer             Error
      Common / FNERR /    Error

      Error = 0
      RITER = X0
      N     = 0
      X_old = RITER
      RITER = Funct( RITER )
      Dist  = Abs( RITER - X_old )
 1    Continue
      Dst   = Dist
      X_old = RITER
      RITER = Funct( RITER )
      Dist  = Abs( RITER - X_old )
      If ( Dist .le. Eps * Abs( RITER ) ) Return
      If ( Dist .ge. Dst ) N = N + 1
      If ( N .gt. Max_Away ) Go to 2001
      GO TO 1
 2001 Continue
      Error = 2001
      Return
      End
